<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Security\Core\User\UserInterface;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\User
 *
 * @ORM\Table(name="users",indexes={@ORM\Index(name="user_internal_idx", columns={"internal_user"})})
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\UserRepository")
 * @ORM\HasLifecycleCallbacks()
 *
 * @ExclusionPolicy("all")
 */
class User implements UserInterface, \Serializable
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $id;

    /**
     * @var string $username
     *
     * @ORM\Column(name="username", type="string", length=255, unique=true)
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $username;

    /**
     * @var string $email
     *
     * @ORM\Column(name="email", type="string")
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $email;

    /**
     * @var string $last_login
     *
     * @ORM\Column(name="last_login", type="datetime", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"details"})
     */
    private $last_login;

    /**
     * @var string $create_date
     *
     * @ORM\Column(name="create_date", type="datetime")
     */
    private $create_date;

    /**
     * @var string $roles
     *
     * @ORM\Column(name="roles", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"details"})
     */
    private $roles = array();

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $name;

    /**
     * @var string $surname
     *
     * @ORM\Column(name="surname", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"details", "manage","companyDetails"})
     */
    private $surname;

    /**
     * @var string $internal_user
     *
     * @ORM\Column(name="internal_user", type="boolean")
     */
    private $internal_user = false;

    /**
     * @var string $is_deleted
     *
     * @ORM\Column(name="is_deleted", type="boolean")
     */
    private $is_deleted = false;

    /**
     * @var integer
     *
     * @ORM\Column(name="external_id", type="integer", nullable=true)
     */
    private $external_id;

    /**
     * @var integer $visits_count
     *
     * @ORM\Column(name="visits_count", type="integer")
     */
    private $visits_count = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="group_id", type="integer", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"manage","companyDetails"})
     */
    private $groupId;

    /**
     * @var integer
     *
     * @ORM\Column(name="market_segment_id", type="integer", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"details"})
     */
    private $marketSegmentId;

    /**
     * @ORM\ManyToOne(targetEntity="UserGroups",inversedBy="users")
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"manage"})
     */
    private $group;

    /**
     * @ORM\ManyToMany(targetEntity="UserCompanyRoleTypes", inversedBy="users", cascade={"remove"}))
     * @ORM\JoinTable(name="user_company_role_rel",
     *      joinColumns={@ORM\JoinColumn(name="user_id", referencedColumnName="id")},
     *      inverseJoinColumns={@ORM\JoinColumn(name="role_id", referencedColumnName="id")}
     *      )
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $companyRoles;

    /**
     * @ORM\OneToMany(targetEntity="UserTokenList", mappedBy="user", cascade={"remove"})
     * @ORM\OrderBy({"sequence"="DESC"})
     */
    private $tokensList;

    /**
     * @ORM\OneToMany(targetEntity="Company", mappedBy="createUser")
     *
     * @Expose
     * @AnnotationGroups({"details1"})
     */
    private $creatorCompany;

    /**
     * @ORM\OneToMany(targetEntity="UserGroups", mappedBy="user")
     */
    private $adminGroups;

    /**
     * @ORM\OneToMany(targetEntity="UserPageSpentTime", mappedBy="user", cascade={"remove"})
     * @ORM\OrderBy({"createAt" = "DESC"})
     */
    private $pageSpentTimes;

    /**
     * @ORM\ManyToOne(targetEntity="MarketSegment", inversedBy="users")
     * @ORM\JoinColumn(name="market_segment_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    protected $marketSegment;



    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->create_date = new \DateTime();
    }

    public function __construct()
    {
        $this->subjects = new \Doctrine\Common\Collections\ArrayCollection();
        $this->schools = new \Doctrine\Common\Collections\ArrayCollection();
    }


    public function __toString()
    {
        return $this->name . ' ' . $this->surname;
    }


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set username
     *
     * @param string $username
     */
    public function setUsername($username)
    {
        $this->username = $username;
    }

    /**
     * Get username
     *
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * Get password
     *
     * @return string
     */
    public function getPassword()
    {
        return '';
    }

    /**
     * Get salt
     *
     * @return string
     */
    public function getSalt()
    {
        return '';
    }

    /**
     * Set email
     *
     * @param string $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set last_login
     *
     * @param datetime $lastLogin
     */
    public function setLastLogin($lastLogin)
    {
        $this->last_login = $lastLogin;
    }

    /**
     * Get last_login
     *
     * @return datetime
     */
    public function getLastLogin()
    {
        return $this->last_login;
    }

    /**
     * Set create_date
     *
     * @param datetime $createDate
     */
    public function setCreateDate($createDate)
    {
        $this->create_date = $createDate;
    }

    /**
     * Get create_date
     *
     * @return datetime
     */
    public function getCreateDate()
    {
        return $this->create_date;
    }

    /**
     * Set roles
     *
     * @param string $roles
     */
    public function setRoles($roles)
    {
        $this->roles = serialize($roles);
    }

    /**
     * Get roles
     *
     * @return string
     */
    public function getRoles()
    {
        return unserialize($this->roles);
    }

    /**
     * Set name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set surname
     *
     * @param string $surname
     */
    public function setSurname($surname)
    {
        $this->surname = $surname;
    }

    /**
     * Get surname
     *
     * @return string
     */
    public function getSurname()
    {
        return $this->surname;
    }


    public function eraseCredentials()
    {
    }

    public function equals(UserInterface $user)
    {
        if ($user instanceof User) {
            return false;
        }

//        if ($this->getSalt() !== $user->getSalt()) {
//            return false;
//        }

        if ($this->username !== $user->getUsername()) {
            return false;
        }

        return true;
    }

    public function serialize()
    {
        return serialize($this->getUsername());
    }


    public function unserialize($serialized)
    {
        $this->username = unserialize($serialized);
    }

    /**
     * Set internal_user
     *
     * @param boolean $internalUser
     */
    public function setInternalUser($internalUser)
    {
        $this->internal_user = $internalUser;
    }

    /**
     * Get internal_user
     *
     * @return boolean 
     */
    public function getInternalUser()
    {
        return $this->internal_user;
    }

    /**
     * Set is_deleted
     *
     * @param boolean $isDeleted
     */
    public function setIsDeleted($isDeleted)
    {
        $this->is_deleted = $isDeleted;
    }

    /**
     * Get is_deleted
     *
     * @return boolean 
     */
    public function getIsDeleted()
    {
        return $this->is_deleted;
    }

    /**
     * Set visits_count
     *
     * @param integer $visits_count
     */
    public function setVisitsCount($visits_count)
    {
        $this->visits_count = $visits_count;
    }

    /**
     * Get visits_count
     *
     * @return integer
     */
    public function getVisitsCount()
    {
        return $this->visits_count;
    }

    public function increaseVisitsCount()
    {
        $this->setVisitsCount(++$this->visits_count);
    }

    public function removeRole($role)
    {
        $roles = $this->getRoles();
        $index = array_search($role, $roles);
        if($index !== false)
        {
            unset($roles[$index]);
            $this->setRoles($roles);
        }
        return true;
    }

    /**
     * Set external_id
     *
     * @param integer $externalId
     * @return User
     */
    public function setExternalId($externalId)
    {
        $this->external_id = $externalId;

        return $this;
    }

    /**
     * Get external_id
     *
     * @return integer
     */
    public function getExternalId()
    {
        return $this->external_id;
    }

    /**
     * Set groupId
     *
     * @param integer $groupId
     * @return User
     */
    public function setGroupId($groupId)
    {
        $this->groupId = $groupId;

        return $this;
    }

    /**
     * Get groupId
     *
     * @return integer
     */
    public function getGroupId()
    {
        return $this->groupId;
    }

    /**
     * Set group
     *
     * @param \VM\ApiBundle\Entity\UserGroups $group
     * @return User
     */
    public function setGroup(\VM\ApiBundle\Entity\UserGroups $group = null)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return \VM\ApiBundle\Entity\UserGroups
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * Add companyRoles
     *
     * @param \VM\ApiBundle\Entity\UserCompanyRoleTypes $companyRoles
     * @return User
     */
    public function addCompanyRole(\VM\ApiBundle\Entity\UserCompanyRoleTypes $companyRoles)
    {
        $this->companyRoles[] = $companyRoles;
    
        return $this;
    }

    /**
     * Remove companyRoles
     *
     * @param \VM\ApiBundle\Entity\UserCompanyRoleTypes $companyRoles
     */
    public function removeCompanyRole(\VM\ApiBundle\Entity\UserCompanyRoleTypes $companyRoles)
    {
        $this->companyRoles->removeElement($companyRoles);
    }

    /**
     * Get companyRoles
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyRoles()
    {
        return $this->companyRoles;
    }

    /**
     * Add creatorCompany
     *
     * @param \VM\ApiBundle\Entity\Company $creatorCompany
     * @return User
     */
    public function addCreatorCompany(\VM\ApiBundle\Entity\Company $creatorCompany)
    {
        $this->creatorCompany[] = $creatorCompany;
    
        return $this;
    }

    /**
     * Remove creatorCompany
     *
     * @param \VM\ApiBundle\Entity\Company $creatorCompany
     */
    public function removeCreatorCompany(\VM\ApiBundle\Entity\Company $creatorCompany)
    {
        $this->creatorCompany->removeElement($creatorCompany);
    }

    /**
     * Get creatorCompany
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCreatorCompany()
    {
        return $this->creatorCompany;
    }

    /**
     * Add adminGroups
     *
     * @param \VM\ApiBundle\Entity\UserGroups $adminGroups
     * @return User
     */
    public function addAdminGroup(\VM\ApiBundle\Entity\UserGroups $adminGroups)
    {
        $this->adminGroups[] = $adminGroups;
    
        return $this;
    }

    /**
     * Remove adminGroups
     *
     * @param \VM\ApiBundle\Entity\UserGroups $adminGroups
     */
    public function removeAdminGroup(\VM\ApiBundle\Entity\UserGroups $adminGroups)
    {
        $this->adminGroups->removeElement($adminGroups);
    }

    /**
     * Get adminGroups
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getAdminGroups()
    {
        return $this->adminGroups;
    }

    /**
     * Add tokensList
     *
     * @param \VM\ApiBundle\Entity\UserTokenList $tokensList
     * @return User
     */
    public function addTokensList(\VM\ApiBundle\Entity\UserTokenList $tokensList)
    {
        $this->tokensList[] = $tokensList;
    
        return $this;
    }

    /**
     * Remove tokensList
     *
     * @param \VM\ApiBundle\Entity\UserTokenList $tokensList
     */
    public function removeTokensList(\VM\ApiBundle\Entity\UserTokenList $tokensList)
    {
        $this->tokensList->removeElement($tokensList);
    }

    /**
     * Get tokensList
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokensList()
    {
        return $this->tokensList;
    }

    /**
     * Add pageSpentTimes
     *
     * @param \VM\ApiBundle\Entity\UserPageSpentTime $pageSpentTimes
     * @return User
     */
    public function addPageSpentTime(\VM\ApiBundle\Entity\UserPageSpentTime $pageSpentTimes)
    {
        $this->pageSpentTimes[] = $pageSpentTimes;
    
        return $this;
    }

    /**
     * Remove pageSpentTimes
     *
     * @param \VM\ApiBundle\Entity\UserPageSpentTime $pageSpentTimes
     */
    public function removePageSpentTime(\VM\ApiBundle\Entity\UserPageSpentTime $pageSpentTimes)
    {
        $this->pageSpentTimes->removeElement($pageSpentTimes);
    }

    /**
     * Get pageSpentTimes
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPageSpentTimes()
    {
        return $this->pageSpentTimes;
    }

    /**
     * Set marketSegmentId
     *
     * @param integer $marketSegmentId
     * @return User
     */
    public function setMarketSegmentId($marketSegmentId)
    {
        $this->marketSegmentId = $marketSegmentId;
    
        return $this;
    }

    /**
     * Get marketSegmentId
     *
     * @return integer 
     */
    public function getMarketSegmentId()
    {
        return $this->marketSegmentId;
    }

    /**
     * Set marketSegment
     *
     * @param \VM\ApiBundle\Entity\MarketSegment $marketSegment
     * @return User
     */
    public function setMarketSegment(\VM\ApiBundle\Entity\MarketSegment $marketSegment = null)
    {
        $this->marketSegment = $marketSegment;
    
        return $this;
    }

    /**
     * Get marketSegment
     *
     * @return \VM\ApiBundle\Entity\MarketSegment 
     */
    public function getMarketSegment()
    {
        return $this->marketSegment;
    }
}